**************************************************************************************
*	BIOS_S.S
*
*	TOS BIOS calling routines
*
*	[c] 2001 Reservoir Gods
**************************************************************************************

**************************************************************************************
;	EXPORTS / IMPORTS
**************************************************************************************

	export	Bios_Bconin
	export	Bios_Bconout
	export	Bios_Bconstat
	export	Bios_Drvmap
	export	Bios_Getmbpb
	export	Bios_Kbshift
	export	Bios_Mediach
	export	Bios_Rwabs
	export	Bios_Setexec

**************************************************************************************
;	EQUATES
**************************************************************************************

**************************************************************************************
;	MACROS
**************************************************************************************

	MACRO	mBIOS	aOP

	pea		(a2)
	move.w	#aOP,-(a7)
	trap	#13
	addq.l	#2,a7
	move.l	(a7)+,a2

	ENDM

*------------------------------------------------------------------------------------*

	MACRO	mBIOS_W	aOP

	pea		(a2)
	move.w	d0,-(a7)
	move.w	#aOP,-(a7)
	trap	#13
	addq.l	#4,a7
	move.l	(a7)+,a2

	ENDM

*------------------------------------------------------------------------------------*

	MACRO	mBIOS_WW	aOP

	pea		(a2)
	move.w	d1,-(a7)
	move.w	d0,-(a7)
	move.w	#aOP,-(a7)
	trap	#13
	addq.l	#6,a7
	move.l	(a7)+,a2

	ENDM

*------------------------------------------------------------------------------------*

	MACRO	mBIOS_P	aOP

	pea		(a2)
	pea		(a0)
	move.w	#aOP,-(a7)
	trap	#13
	addq.l	#6,a7
	move.l	(a7)+,a2

	ENDM

*------------------------------------------------------------------------------------*

	MACRO	mBIOS_WP	aOP

	pea		(a2)
	pea		(a0)
	move.w	d0,-(a7)
	move.w	#aOP,-(a7)
	trap	#13
	addq.l	#6,a7
	move.l	(a7)+,a2

	ENDM


**************************************************************************************
	TEXT
**************************************************************************************

*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Bconin
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Bconin:
	mBIOS	2
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Bconout
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Bconout:
	mBIOS_WW	3
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Bconstat
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Bconstat:
	mBIOS_W	1
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Drvmap
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Drvmap:
	mBIOS	10
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Getbpb
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Getbpb:
	mBIOS_W	7
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Getmbpb
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Getmbpb:
	mBIOS_P	0
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Kbshift
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Kbshift:
	mBIOS_W	11
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Mediach
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Mediach:
	mBIOS_W	9
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Rwabs
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Rwabs:
	pea		(a2)

	lea		4(a7),a2
	move.l	(a2)+,-(a7)
	move.w	(a2)+,-(a7)
	move.w	d2,-(a7)
	move.w	d1,-(a7)
	pea		(a0)
	move.w	d0,-(a7)
	move.w	#4,-(a7)
	trap	#13
	lea		18(a7),a7

	move.l	(a7)+,a2
	rts


*------------------------------------------------------------------------------------*
* FUNCTION : Bios_Setexec
* ACTION   : 
* CREATION : 11.11.01 PNK
*------------------------------------------------------------------------------------*

Bios_Setexec:
	mBIOS_WP	5
	rts
